/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.model;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.entity.NPCRendererHelper;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.Slot;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.client.gui.model.GuiCreationParts;
import noppes.npcs.client.gui.model.GuiCreationScreenInterface;
import noppes.npcs.client.gui.util.GuiButtonBiDirectional;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcButtonYesNo;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IGuiCustomScroll;
import noppes.npcs.containers.ContainerLayer;
import noppes.npcs.controllers.PixelmonHelper;
import noppes.npcs.entity.EntityFakeLiving;
import noppes.npcs.entity.EntityNPCInterface;

public class GuiCreationExtra
extends GuiCreationScreenInterface
implements ICustomScrollListener {
    public String[] booleanTags;
    private Map<String, GuiType> data;
    private final String[] ignoredTags = new String[]{"CanBreakDoors", "Bred", "PlayerCreated", "HasReproduced"};
    private GuiCustomScroll scroll;
    private GuiType selected;

    public GuiCreationExtra(EntityNPCInterface npc, ContainerLayer container) {
        super(npc, container);
        this.booleanTags = new String[0];
        this.data = new HashMap<String, GuiType>();
        this.active = 2;
    }

    @Override
    protected void func_146284_a(@Nonnull GuiButton btn) {
        super.func_146284_a(btn);
        if (this.selected != null) {
            this.selected.actionPerformed(btn);
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (!CustomNpcs.ShowDescriptions) {
            return;
        }
        String part = this.scroll.getSelected().toLowerCase();
        if (this.getButton(1) != null && this.getButton(1).isHovered()) {
            this.setHoverText(new TextComponentTranslation("display.hover.part.entity", new Object[0]).func_150254_d(), new Object[0]);
        } else if (this.getButton(2) != null && this.getButton(2).isHovered()) {
            this.setHoverText(new TextComponentTranslation("display.hover.extra", new Object[0]).func_150254_d(), new Object[0]);
        } else if (this.getButton(4) != null && this.getButton(4).isHovered()) {
            this.setHoverText(new TextComponentTranslation("display.hover.part.save", new Object[0]).func_150254_d(), new Object[0]);
        } else if (this.getButton(5) != null && this.getButton(5).isHovered()) {
            this.setHoverText(new TextComponentTranslation("display.hover.part.load", new Object[0]).func_150254_d(), new Object[0]);
        } else if (this.getButton(11) != null && this.getButton(11).isHovered()) {
            this.setHoverText(new TextComponentTranslation("display.hover.part." + part, new Object[0]).func_150254_d(), new Object[0]);
        } else if (this.getButton(66) != null && this.getButton(66).isHovered()) {
            this.setHoverText(new TextComponentTranslation("hover.back", new Object[0]).func_150254_d(), new Object[0]);
        } else if (this.scroll != null && this.scroll.hover > -1) {
            this.drawHoveringText(Collections.singletonList(new TextComponentTranslation("display.hover.part." + this.scroll.getList().get(this.scroll.hover).toLowerCase(), new Object[0]).func_150254_d()), mouseX, mouseY, this.field_146289_q);
        } else {
            for (GuiButton b : this.field_146292_n) {
                if (b == null || !b.func_146115_a() || b.field_146127_k != 500) continue;
                this.setHoverText(new TextComponentTranslation("display.hover.part.rotate", new Object[0]).func_150254_d(), new Object[0]);
            }
        }
        this.drawHoverText(null, new Object[0]);
    }

    public Map<String, GuiType> getData(EntityLivingBase entity) {
        HashMap<String, GuiType> data = new HashMap<String, GuiType>();
        NBTTagCompound compound = this.getExtras(entity);
        Set keys = compound.func_150296_c();
        for (String name : keys) {
            byte b;
            if (this.isIgnored(name)) continue;
            NBTBase base = compound.func_74781_a(name);
            if (name.equals("Age")) {
                data.put("Child", new GuiTypeBoolean("Child", entity.func_70631_g_()));
                continue;
            }
            if (name.equals("Color") && base.func_74732_a() == 1) {
                data.put("Color", new GuiTypeByte("Color", compound.func_74771_c("Color")));
                continue;
            }
            if (base.func_74732_a() != 1 || (b = ((NBTTagByte)base).func_150290_f()) != 0 && b != 1) continue;
            if (this.playerdata.extra.func_74764_b(name)) {
                b = this.playerdata.extra.func_74771_c(name);
            }
            data.put(name, new GuiTypeBoolean(name, b == 1));
        }
        if (PixelmonHelper.isPixelmon((Entity)entity)) {
            data.put("Model", new GuiTypePixelmon("Model"));
        }
        if (Objects.equals(EntityList.func_75621_b((Entity)entity), "tgvstyle.Dog")) {
            data.put("Breed", new GuiTypeDoggyStyle("Breed"));
        }
        return data;
    }

    private NBTTagCompound getExtras(EntityLivingBase entity) {
        NBTTagCompound fake = new NBTTagCompound();
        new EntityFakeLiving(entity.field_70170_p).func_70014_b(fake);
        NBTTagCompound compound = new NBTTagCompound();
        try {
            entity.func_70014_b(compound);
        }
        catch (Exception e) {
            LogWriter.error(e);
        }
        Set keys = fake.func_150296_c();
        for (String name : keys) {
            compound.func_82580_o(name);
        }
        return compound;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.entity == null) {
            this.openGui((GuiScreen)new GuiCreationParts(this.npc, (ContainerLayer)this.field_147002_h));
            return;
        }
        if (this.scroll == null) {
            this.data = this.getData(this.entity);
            this.scroll = new GuiCustomScroll(this, 0);
            ArrayList<String> list = new ArrayList<String>(this.data.keySet());
            this.scroll.setList(list);
            if (list.isEmpty()) {
                return;
            }
            this.scroll.setSelected((String)list.get(0));
        }
        this.selected = this.data.get(this.scroll.getSelected());
        if (this.selected == null) {
            return;
        }
        this.scroll.guiLeft = this.field_147003_i;
        this.scroll.guiTop = this.field_147009_r + 46;
        this.scroll.setSize(100, this.field_147000_g - 74);
        this.addScroll(this.scroll);
        this.selected.initGui();
        for (Slot slot : this.field_147002_h.field_75151_b) {
            slot.field_75223_e = -5000;
            slot.field_75221_f = -5000;
        }
    }

    private boolean isIgnored(String tag) {
        for (String s : this.ignoredTags) {
            if (!s.equals(tag)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void scrollClicked(int mouseX, int mouseY, int mouseButton, IGuiCustomScroll scroll) {
        if (scroll.getID() == 0) {
            this.func_73866_w_();
        } else if (this.selected != null) {
            this.selected.scrollClicked(mouseX, mouseY, mouseButton, scroll);
        }
    }

    @Override
    public void scrollDoubleClicked(String selection, IGuiCustomScroll scroll) {
    }

    private void updateTexture() {
        EntityLivingBase entity = this.playerdata.getEntity(this.npc);
        RenderLivingBase render = (RenderLivingBase)this.field_146297_k.func_175598_ae().func_78713_a((Entity)entity);
        assert (render != null);
        this.npc.display.setSkinTexture(NPCRendererHelper.getTexture((RenderLivingBase<EntityLivingBase>)render, entity));
    }

    class GuiTypePixelmon
    extends GuiType {
        public GuiTypePixelmon(String name) {
            super(name);
        }

        @Override
        public void initGui() {
            GuiCustomScroll scroll = new GuiCustomScroll(GuiCreationExtra.this, 1);
            scroll.setSize(120, 200);
            scroll.guiLeft = GuiCreationExtra.this.field_147003_i + 120;
            scroll.guiTop = GuiCreationExtra.this.field_147009_r + 20;
            GuiCreationExtra.this.addScroll(scroll);
            scroll.setList(PixelmonHelper.getPixelmonList());
            scroll.setSelected(PixelmonHelper.getName(GuiCreationExtra.this.entity));
        }

        @Override
        public void scrollClicked(int i, int j, int k, IGuiCustomScroll scroll) {
            String name = scroll.getSelected();
            GuiCreationExtra.this.playerdata.setExtra(GuiCreationExtra.this.entity, "name", name);
            GuiCreationExtra.this.updateTexture();
        }
    }

    class GuiTypeDoggyStyle
    extends GuiType {
        public GuiTypeDoggyStyle(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(GuiButton button) {
            if (button.field_146127_k != 11) {
                return;
            }
            EntityLivingBase entity = GuiCreationExtra.this.playerdata.getEntity(GuiCreationExtra.this.npc);
            GuiCreationExtra.this.playerdata.setExtra(entity, "breed", ((GuiNpcButton)button).getValue() + "");
            GuiCreationExtra.this.updateTexture();
        }

        @Override
        public void initGui() {
            Enum breed = null;
            try {
                Method method = GuiCreationExtra.this.entity.getClass().getMethod("getBreedID", Class[].class);
                breed = (Enum)method.invoke((Object)GuiCreationExtra.this.entity, new Object[]{new Class[0]});
            }
            catch (Exception e) {
                LogWriter.error(e);
            }
            if (breed != null) {
                GuiCreationExtra.this.addButton(new GuiButtonBiDirectional(11, GuiCreationExtra.this.field_147003_i + 120, GuiCreationExtra.this.field_147009_r + 45, 50, 20, new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26"}, breed.ordinal()));
            }
        }
    }

    class GuiTypeByte
    extends GuiType {
        private final byte b;

        public GuiTypeByte(String name, byte b) {
            super(name);
            this.b = b;
        }

        @Override
        public void actionPerformed(GuiButton button) {
            if (button.field_146127_k != 11) {
                return;
            }
            GuiCreationExtra.this.playerdata.extra.func_74774_a(this.name, (byte)((GuiNpcButton)button).getValue());
            GuiCreationExtra.this.playerdata.clearEntity();
            GuiCreationExtra.this.updateTexture();
        }

        @Override
        public void initGui() {
            GuiCreationExtra.this.addButton(new GuiButtonBiDirectional(11, GuiCreationExtra.this.field_147003_i + 120, GuiCreationExtra.this.field_147009_r + 45, 50, 20, new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15"}, this.b));
        }
    }

    class GuiTypeBoolean
    extends GuiType {
        private boolean bo;

        public GuiTypeBoolean(String name, boolean bo) {
            super(name);
            this.bo = bo;
        }

        @Override
        public void actionPerformed(GuiButton button) {
            if (button.field_146127_k != 11) {
                return;
            }
            this.bo = ((GuiNpcButtonYesNo)button).getBoolean();
            if (this.name.equals("Child")) {
                GuiCreationExtra.this.playerdata.extra.func_74768_a("Age", this.bo ? -24000 : 0);
                GuiCreationExtra.this.playerdata.clearEntity();
            } else {
                GuiCreationExtra.this.playerdata.extra.func_74757_a(this.name, this.bo);
                GuiCreationExtra.this.playerdata.clearEntity();
                GuiCreationExtra.this.updateTexture();
            }
        }

        @Override
        public void initGui() {
            GuiCreationExtra.this.addButton(new GuiNpcButtonYesNo(11, GuiCreationExtra.this.field_147003_i + 120, GuiCreationExtra.this.field_147009_r + 50, 60, 20, this.bo));
        }
    }

    public static abstract class GuiType {
        public String name;

        public GuiType(String name) {
            this.name = name;
        }

        public void actionPerformed(GuiButton button) {
        }

        public void initGui() {
        }

        public void scrollClicked(int i, int j, int k, IGuiCustomScroll scroll) {
        }
    }
}

